# ServerEvents.tags

## Basic info

- Valid script types: [SERVER]

- Has result? ✘

- Event class: [TagEventJS](https://github.com/KubeJS-Mods/KubeJS/tree/2001/common/src/main/java/dev/latvian/mods/kubejs/server/tag/TagEventJS.java)

### Available fields:

| Name | Type | Static? |
| ---- | ---- | ------- |
| TAG_EVENT_HANDLER | EventExceptionHandler | ✔ |
| SOURCE | String | ✔ |
| registry | RegistryInfo | ✘ |
| vanillaRegistry | Registry<?> | ✘ |
| tags | Map<ResourceLocation, TagWrapper> | ✘ |
| totalAdded | int | ✘ |
| totalRemoved | int | ✘ |

Note: Even if no fields are listed above, some methods are still available as fields through *beans*.

### Available methods:

| Name | Parameters | Return type | Static? |
| ---- | ---------- | ----------- | ------- |
| remove | ResourceLocation, Object[] |  | TagWrapper | ✘ |
| get | ResourceLocation |  | TagWrapper | ✘ |
| add | ResourceLocation, Object[] |  | TagWrapper | ✘ |
| getType |  |  | ResourceLocation | ✘ |
| removeAll | ResourceLocation |  | TagWrapper | ✘ |
| removeAllTagsFrom | Object[] |  | void | ✘ |
| getElementIds |  |  | Set<ResourceLocation> | ✘ |
| exit | Object |  | Object | ✘ |
| exit |  |  | Object | ✘ |
| cancel | Object |  | Object | ✘ |
| cancel |  |  | Object | ✘ |
| success | Object |  | Object | ✘ |
| success |  |  | Object | ✘ |


### Documented members:

- `Object exit(Object var0)`

  Parameters:
  - var0: Object

```
Stops the event with the given exit value. Execution will be stopped **immediately**.

`exit` denotes a `default` outcome.
```

- `Object exit()`
```
Stops the event with default exit value. Execution will be stopped **immediately**.

`exit` denotes a `default` outcome.
```

- `Object cancel(Object var0)`

  Parameters:
  - var0: Object

```
Cancels the event with the given exit value. Execution will be stopped **immediately**.

`cancel` denotes a `false` outcome.
```

- `Object cancel()`
```
Cancels the event with default exit value. Execution will be stopped **immediately**.

`cancel` denotes a `false` outcome.
```

- `Object success(Object var0)`

  Parameters:
  - var0: Object

```
Stops the event with the given exit value. Execution will be stopped **immediately**.

`success` denotes a `true` outcome.
```

- `Object success()`
```
Stops the event with default exit value. Execution will be stopped **immediately**.

`success` denotes a `true` outcome.
```



### Example script:

```js
ServerEvents.tags(extra_id, (event) => {
	// This space (un)intentionally left blank
});
```

